#include "TCPIPConfig.h"

#include "TCPIP Stack/TCPIP.h"
#include "TCPIP Stack/StackTsk.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "lcd.h"
#include "node.h"
#include "dprs_symbol.h"
#include "crc.h"

#include <stdlib.h>
#include <ctype.h>

#include "GenericTypeDefs.h"
#include "HardwareProfile.h"
#include "usb_config.h"
#include "USB/usb.h"
#include "USB/usb_host_generic.h"
#include "../include/USB/timer.h"
#include "../USB/usb_host_local.h"
#include "MDD File System/FSIO.h"
#include "MDD File System/FSDefs.h"

// Defines how long to wait before assuming the query has failed
#define DPLUS_REPLY_TIMEOUT		(5ul*TICK_SECOND)

#define DPLUS_OPEN_TIMEOUT		(5ul*TICK_SECOND)

#define	MAX_RETRY_CONNECT_CALLSERVER	5

#define	MaxReConnectCnt	20
#define	MaxDprsReConnectCnt	30
#define	DCS_TimeOut	 (30ul*TICK_SECOND)

// These are normally available network time servers.
// The actual IP returned from the pool will vary every
// minute so as to spread the load around stratum 1 timeservers.
// For best accuracy and network overhead you should locate the 
// pool server closest to your geography, but it will still work
// if you use the global pool.ntp.org address or choose the wrong 
// one or ship your embedded device to another geography.

void	DisplayIPValue(DWORD dwServerIP, char Text[]);
BOOL	CheckForNewAttach ( void );
void	usb_send_header (BYTE pkt[]);
void	usb_send_voice (BYTE pkt[]);
void	RF_CallsignPrint ( void );
void	send_dv_header(packet pkt);
void	send_dv_packet(packet pkt);
void	vTaskDelay( portTickType xTicksToDelay );
void	flushData(void);
void	MACWriteArray(BYTE address, BYTE *val, WORD wLen);
WORD	CalcIPChecksum(BYTE *AppConfig, WORD length);
void	KeepAliveSend( void );
void	ReLoadMsg(void);
void	InetHeaderLog(void);
void	GetRefDateTime(void);
void	DprsDataInet(BYTE SlowData[]);
static	BOOL	gps_sumcheck(BYTE string[]);
static	void	GPGLL (BYTE string[]);
static	void	GPGGA (BYTE string[]);
static	void	GPRMC (BYTE string[]);
static	void	RadioDprs_Send();
static	void	InetDprs_Send();
static	void	Radio_GPS_A_Send();
static	void	Inet_GPS_A_Send();
static	void	Inet_GPS_A(BYTE string[]);
static	void	dprs_message (BYTE string[]);
static	BOOL	GPS_A_SumCheck(BYTE string[]);
static	WORD	update_crc_dstar( WORD crc, BYTE c );
static	WORD	result_crc_dstar(WORD crc);
void	DprsProcess(void);
void	DprsBeacon_Send(void);
static	void	GetDprsMessage(void);
static	void	DprsMsgSend(BYTE Msg[]);
void	DprsSMTP(void);
static	void	DprsAck(BYTE SeqID[]);
void	AprsMsgSend(void);
void	RefSolved(void);


BYTE    deviceAddress;  // Address of the device on the USB

DWORD	KeepAliveTimer;

BYTE	RefNameSave[8];
BYTE	RefNameTemp[8];
BYTE	RefNameSet;
BYTE	CurServerName[20];
BYTE	MyCallSign[8];
//static	BYTE	SlowData[6];

BYTE	RefSkipSW;

static	BYTE	ReDprsConnectCnt;
static	BYTE	ReDprsConnectCount;

extern	BYTE	RoomName[8];
extern	BYTE	NodeName[8];
extern	WORD 	out_port;
extern	WORD 	in_port;
extern	WORD	seq;
extern	WORD	SSN;
extern	BYTE	PicVer[2];

extern	BYTE HeaderID[2];
extern	BYTE VoiceID[2];
extern	BYTE LastFrameID[2];
extern	BYTE CurUser[8];

static	char text[120];
extern	BYTE	DPRS_SW;
extern	struct DPRSinfo DPRS;
BYTE	AprsMsgTX[3];
BYTE	EmailAddress[48];
extern	BOOL 	AprsMessageSend;
extern	BYTE	AprsDest[9];
extern	BYTE	AprsMessage[70];
extern	BYTE	AprsSenderCall[10];
extern	DWORD	AprsSeq;
extern	DWORD	RcvAprsSeq;


extern	BYTE	RefDomainName[110];
extern	BOOL	ReqRefDomainName;

extern	xQueueHandle xDstarSndQueue;
extern	xQueueHandle xDstarRcvQueue;
extern	xQueueHandle xDstarRefQueue;
extern	xQueueHandle xDstarLogQueue;
extern	xQueueHandle xDstarDprsMsgQueue;
extern	xQueueHandle xDstarDprsEmailMsgQueue;

//extern	xTaskHandle TCPHandle;

struct	MessageSW 	Msg;

//UDP_SOCKET	ServerSocket = INVALID_UDP_SOCKET;
//UDP_SOCKET	RcvDPlusSocket = INVALID_UDP_SOCKET;



extern	BYTE	TimeDate[20];
extern	BOOL	headerRead;
extern	BOOL	CallCheck_Skip;

struct	RefDateTime	RDateTime;

extern	BYTE	Inet_Callsign_Check_String[9];

static	BYTE DprsTemp[512];
static	BYTE i,k;

BYTE	InetLat[8], InetLong[9];
BYTE	InetCall[8];
BYTE	InetMsg[20];
BYTE	InetAtitude[6];
BYTE	InetSpeed[3];
BYTE	InetDirection[3];
BYTE	RadioLat[8], RadioLong[9];
BYTE	RadioCall[8];
BYTE	RadioMsg[20];
BYTE	RadioAtitude[6];
BYTE	RadioSpeed[3];
BYTE	RadioDirection[3];
BYTE	Radio_GPS_A_MSG[120];
BYTE	Inet_GPS_A_MSG[120];
BOOL	Radio_GPS_A_Msg_send;
BOOL	Inet_GPS_A_Msg_send;
BOOL	DprsOpen = FALSE;
static	DWORD	AprsInetTimer = 0;
static	DWORD	AprsRadioTimer = 0;
static	DWORD	DprsBeaconTimer = 0;
extern	BYTE	DprsMsgDstCallSign[10];
extern	BYTE	DprsMsgSrcCallSign[10];
extern	struct	AprsCallTable	*AprsCallTablePnt;
extern	BYTE	AprsCallTBLCnt;
extern	BOOL	ReqLoadAprsCallCheck;
BYTE	DprsMsgDstCallSignSave[9];

BOOL	RadioDprsSend, InetDprsSend;
extern	BOOL	ReqConvertLocalRefFile;
extern	BOOL	ReqRefDomainName;
extern	BYTE	RefDomainName[110];

extern	BOOL	DebugSW;

TCP_SOCKET	DprsSocket = INVALID_SOCKET;

	
static	BYTE	dprs_data[150];
static	BYTE	dprs_pnt = 0;

void	DprsDataInet(BYTE Sdata[])
{
	static	BYTE	len;
		len = Sdata[0] &0x0f;
		if ((dprs_pnt + len) >= 120)
		{
			dprs_pnt = 0;
			return;
		} 
		memcpy (&dprs_data[dprs_pnt], &Sdata[1], len);
		dprs_pnt += len;
		if (dprs_data[dprs_pnt - 1] == 0x0d) dprs_data[dprs_pnt++] = 0x0a;
		if (dprs_data[dprs_pnt - 1] == 0x0a)
		{
			if (DebugSW) xQueueSend( xDstarLogQueue, &dprs_data, 0 );
			if (gps_sumcheck(dprs_data))
			{
					dprs_data[dprs_pnt - 1] = 0x00;
					if(!memcmp (dprs_data, "$GPGLL,", 7)) GPGLL (&dprs_data[7]);
					else if(!memcmp (dprs_data, "$GPGGA,", 7)) GPGGA (&dprs_data[7]);
					else if(!memcmp (dprs_data, "$GPRMC,", 7)) GPRMC (&dprs_data[7]);
					else if(!memcmp (dprs_data, "$$CRC", 5)) Inet_GPS_A (&dprs_data[10]);
					else if(dprs_data[0] != '$') dprs_message(dprs_data);
			}

			dprs_pnt = 0;
		} 
}


static	BOOL	gps_sumcheck(BYTE string[])
{
	BYTE	*pnt;
	static	BYTE	sum, csum, tmp;

	if (!memcmp (string, "$$CRC", 5))
	{
		return GPS_A_SumCheck(string);
	}
	pnt = string;
	sum = 0;
	if (*pnt == '$') pnt++;
	while (*pnt !='*')
	{
		if ((*pnt == 0x0a) || (*pnt == 0x0d)) return FALSE;
		sum ^= *pnt;
		pnt++;
	}
	pnt++;
	tmp = *pnt - '0';
	if (tmp > 16) tmp -= 7;
	csum = tmp << 4;
	pnt++;
	tmp = *pnt - '0';
	if (tmp > 16) tmp -= 7;
	csum += tmp;
	if (csum == sum) return TRUE;
	return FALSE;
}

static	void	GPGLL (BYTE string[])
{
	static	BYTE	*pnt;
	static	BYTE	i;

	pnt = string;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 7)
		{
			InetLat[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	RadioLat[7] = *pnt;
	pnt += 2;

	i = 0;
	while (*pnt != ',')
	{
		if (i < 8)
		{
			InetLong[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLong[8] = *pnt;
}

static	void	GPGGA (BYTE string[])
{
	static	BYTE	*pnt;
	static	BYTE	i;
	static	DWORD	d;
	static	BYTE	tmp[10];
	static	WORD	k;

	pnt = string;
	while (*pnt != ',') pnt++;
	pnt++;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 7)
		{
			InetLat[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLat[7] = *pnt;
	pnt += 2;

	i = 0;
	while (*pnt != ',')
	{
		if (i < 8)
		{
			InetLong[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLong[8] = *pnt;

	pnt += 2;
	while (*pnt != ',') pnt++;
	pnt++;
	while (*pnt != ',') pnt++;
	pnt++;
	while (*pnt != ',') pnt++;
	pnt++;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 8)
		{
			tmp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	tmp[i] = 0x00;
	d = atof ((char *)tmp);
	k = d / 0.3048 + 0.5;
	sprintf ((char *)InetAtitude, "%06d", k); 
}

static	void	GPRMC (BYTE string[])
{
	static	DWORD	d;
	static	BYTE	tmp[10];
	static	WORD	k;
	static	BYTE	*pnt;
	static	BYTE	i;

	pnt = string;
	while (*pnt != ',') pnt++;
	pnt++;
	while (*pnt != ',') pnt++;
	pnt++;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 7)
		{
			InetLat[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLat[7] = *pnt;
	pnt += 2;

	i = 0;
	while (*pnt != ',')
	{
		if (i < 8)
		{
			InetLong[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLong[8] = *pnt;
	pnt += 2;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 9)
		{
			tmp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	tmp[i] = 0x00;
	d = atof ((char *)tmp);
	k = d + 0,5;
	sprintf ((char *)InetSpeed, "%03d", k);

	pnt++;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 9)
		{
			tmp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	tmp[i] = 0x00;
	d = atof ((char *)tmp);
	k = d + 0,5;
	sprintf ((char *)InetDirection, "%03d", k);
}

static	void	dprs_message (BYTE string[])
{
	static	BYTE	*pnt;
	static	BYTE	i, k;
	static	BYTE	len;

//	len = strlen ((char *)&string);
//	if (len <= 9) return;

	pnt = string;
	i = 0;
	memset (InetCall, 0x20, 8);
	while (*pnt != ',')
	{
		if (*pnt == 0x00) return;
		if (i < 8)
		{
			InetCall[i] = *pnt;
			i++;
		}
		pnt++;
	}
	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (InetCall[i] != 0x20)
		{
			InetCall[k] = InetCall[i];
			k++;
		} else {
			if (InetCall[k-1] != '-')
			{
				InetCall[k] = '-';
				k++;
			}
		}
	}

	if (InetCall[k-1] == '-') InetCall[k-1] = 0x00;

	if (k < 7)
	{
		for (i = k ; i < 8 ; i++)
		{
			InetCall[k] = 0x00;
		}
	}

	memset (InetMsg, 0x00, 20);
	len = strlen ((char *)&string[9]);
	if (len == 0) return;
	memcpy (InetMsg, &string[9], len);
	InetDprsSend = TRUE;
}


/*
	CRC update routine
 */

static	WORD	update_crc_dstar( WORD crc, BYTE c )
{
    WORD tmp, short_c;

    short_c  = 0x00ff &  c;
	
    tmp = (crc & 0x00ff) ^ short_c;
    crc = (crc >> 8)  ^ crc_tabccitt[tmp];

    return crc;

}  /* update_crc_dstar */


/*
	CRC reslut routine
 */

static	WORD		result_crc_dstar(WORD crc)
{

    WORD tmp;

      crc = ~crc;
      tmp = crc;
      crc = (crc << 8) | (tmp >> 8 & 0xff);

    return crc;

}  /* result_crc_dstar */

static BOOL	GPS_A_SumCheck(BYTE string[])
{
	static	WORD	crc_dstar_ffff, k, k0, k1, k2, k3;
	static	BYTE	*pnt;
	
    crc_dstar_ffff = 0xffff;	/* nornal value 0xffff */
	pnt = string + 10;

	while (*pnt != 0x0a)
	{
		crc_dstar_ffff = update_crc_dstar( crc_dstar_ffff, *pnt);
		pnt++;
	}

	crc_dstar_ffff = result_crc_dstar(crc_dstar_ffff);

	k0 = string[5] - '0';
	if (k0 > 16) k0 -= 7;
	k1 = string[6] - '0';
	if (k1 > 16) k1 -= 7;
	k2 = string[7] - '0';
	if (k2 > 16) k2 -= 7;
	k3 = string[8] - '0';
	if (k3 > 16) k3 -= 7;
	k1 += k0 * 16;
	k3 += k2 * 16;
    k = k1 | (k3 << 8);

	if (k == crc_dstar_ffff) return TRUE;
	return	FALSE;
}

static	void	Inet_GPS_A (BYTE string[])
{
	memcpy (Inet_GPS_A_MSG, string, strlen((char *)string));
	Inet_GPS_A_Msg_send = TRUE;
}


static	void	InetDprs_Send()
{
	static	BYTE	id[9];
	static	BYTE	msg_len;
	static	WORD	l, n;

	if ((TickGet() - AprsInetTimer) <= 29*TICK_SECOND) return;

	if(TCPIsPutReady(DprsSocket) < 150u) return;
	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			id[k] = DPRS.CallSign[i];
			k++;
		}
		else
		{
			if (k > 0)
			{
				if(id[k-1] != '-')
				{
					id[k] = '-';
					k++;
				}
			}
		}
	}
	id[k] = 0x00;
	msg_len = 4;
	while (InetMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;

	n = 0;
	l = 9999;
	while (memcmp(aprs_symbol[n][1], "    ", 4))
	{
		if (!memcmp(aprs_symbol[n][1], InetMsg, 4))
		{
			l = n;
			break;
		}
		n++;
	}
	if (l == 9999) l = 29;	// car
	TCPPutArray (DprsSocket, InetCall, strlen((char *)InetCall));
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,DSTAR*,qAR,",19);
	TCPPutArray (DprsSocket, id, k);
	if (msg_len) TCPPutArray (DprsSocket, (BYTE *)":=", 2);
	else TCPPutArray (DprsSocket, (BYTE *)":!", 2);
	TCPPutArray (DprsSocket, InetLat, 8);
	TCPPut (DprsSocket, aprs_symbol[l][0][0]);
	TCPPutArray (DprsSocket, InetLong, 9);
	TCPPut (DprsSocket, aprs_symbol[l][0][1]);
	if (RadioDirection[0] != 0x00)
		TCPPutArray (DprsSocket, InetDirection, 3);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000", 3);
	TCPPut (DprsSocket, '/');
	if (InetSpeed[0] != 0x00)
		TCPPutArray (DprsSocket, InetSpeed, 3);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000", 3);
	TCPPutArray (DprsSocket, (BYTE *)"/A=", 3);
	if (InetAtitude[0] != 0x00)
		TCPPutArray (DprsSocket, InetAtitude, 6);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000000", 6);
	msg_len = 4;
	while (InetMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;
	if (msg_len > 0) TCPPutArray (DprsSocket, &InetMsg[4], msg_len);
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);

	InetDprsSend = FALSE;		
	memset (InetDirection, 0x00, 3);
	memset (InetSpeed, 0x00, 3);
	memset (InetAtitude, 0x00, 6);
	AprsInetTimer = TickGet();
}

static	void	RadioDprs_Send()
{
	static	BYTE	id[9];
	static	BYTE	msg_len;
	static	WORD	l, n;

	if ((TickGet() - AprsRadioTimer) <= 29*TICK_SECOND) return;

	if(TCPIsPutReady(DprsSocket) < 200u) return;
	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			id[k] = DPRS.CallSign[i];
			k++;
		}
		else
		{
			if (k > 0)
			{
				if(id[k-1] != '-')
				{
					id[k] = '-';
					k++;
				}
			}
		}
	}
	id[k] = 0x00;
	msg_len = 4;
	while (RadioMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;

	n = 0;
	l = 9999;
	while (memcmp(aprs_symbol[n][1], "    ", 4))
	{
		if (!memcmp(aprs_symbol[n][1], RadioMsg, 4))
		{
			l = n;
			break;
		}
		n++;
	}
	if (l == 9999) l = 29;	// car
	TCPPutArray (DprsSocket, RadioCall, strlen((char *)RadioCall));
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,DSTAR*,qAR,",19);
	TCPPutArray (DprsSocket, id, k);
	if (msg_len) TCPPutArray (DprsSocket, (BYTE *)":=", 2);
	else TCPPutArray (DprsSocket, (BYTE *)":!", 2);
	TCPPutArray (DprsSocket, RadioLat, 8);
	TCPPut (DprsSocket, aprs_symbol[l][0][0]);
	TCPPutArray (DprsSocket, RadioLong, 9);
	TCPPut (DprsSocket, aprs_symbol[l][0][1]);
	if (RadioDirection[0] != 0x00)
		TCPPutArray (DprsSocket, RadioDirection, 3);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000", 3);
	TCPPut (DprsSocket, '/');
	if (RadioSpeed[0] != 0x00)
		TCPPutArray (DprsSocket, RadioSpeed, 3);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000", 3);
	TCPPutArray (DprsSocket, (BYTE *)"/A=", 3);
	if (RadioAtitude[0] != 0x00)
		TCPPutArray (DprsSocket, RadioAtitude, 6);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000000", 6);
	msg_len = 4;
	while (RadioMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;
	if (msg_len > 0) TCPPutArray (DprsSocket, &RadioMsg[4], msg_len);
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);

	RadioDprsSend = FALSE;		
	memset (RadioDirection, 0x00, 3);
	memset (RadioSpeed, 0x00, 3);
	memset (RadioAtitude, 0x00, 6);
	AprsRadioTimer = TickGet();
}

static	void	Radio_GPS_A_Send()
{
	if ((TickGet() - AprsRadioTimer) > 29*TICK_SECOND)
	{
		if(TCPIsPutReady(DprsSocket) < 120u) return;
		TCPPutArray (DprsSocket, Radio_GPS_A_MSG, strlen((char *)Radio_GPS_A_MSG));
		Radio_GPS_A_Msg_send = FALSE;
		AprsRadioTimer = TickGet();
	}
}

static	void	Inet_GPS_A_Send()
{
	if ((TickGet() - AprsInetTimer) > 58*TICK_SECOND)
	{
		if(TCPIsPutReady(DprsSocket) < 120u) return;
		TCPPutArray (DprsSocket, Inet_GPS_A_MSG, strlen((char *)Inet_GPS_A_MSG));
		Inet_GPS_A_Msg_send = FALSE;
		AprsInetTimer = TickGet();
	}
}

void	DprsProcess()
{
	if(TCPIsConnected(DprsSocket))
	{
		if (!Msg.connectSW && !Msg.notfoundSW)			/* check the still voice message sending? */
		{
			if (RadioDprsSend) RadioDprs_Send();
			if (Radio_GPS_A_Msg_send) Radio_GPS_A_Send();
			if (InetDprsSend) InetDprs_Send();
			if (Inet_GPS_A_Msg_send) Inet_GPS_A_Send();
		}
		if (TCPIsGetReady(DprsSocket)) GetDprsMessage();
	}
	else
	{
		TCPClose (DprsSocket);
		DprsSocket = INVALID_SOCKET;
		Radio_GPS_A_Msg_send = FALSE;
		Inet_GPS_A_Msg_send = FALSE;
		DprsOpen = FALSE;
		sprintf (text, "%19.19s APRS server unlined\n",	TimeDate);
		xQueueSend( xDstarLogQueue, &text, 0 );
		if (DPRS.AutoReLink)
		{
			RefNameSet = 6;
			ReDprsConnectCnt = 0;
			ReDprsConnectCount = 0;
			sprintf (text, "%19.19s APRS server Auto, relink start\n",	TimeDate);
			xQueueSend( xDstarLogQueue, &text, 0 );
		}
	}
}

void	DprsBeacon_Send()
{
	static	BYTE	id[9];
	static	BYTE	msg_len;
	static	long int i;

	if(TCPIsPutReady(DprsSocket) < 70u) return;

	i = labs(DPRS.Lat) % 10000;
	i = i * 6 + 5;
	i /= 10;
	sprintf ((char *)RadioLat, "%02ld%02ld.%02ld" ,labs(DPRS.Lat)/10000, i/100, i%100);
	if (DPRS.Lat >= 0) RadioLat[7] = 'N';
	else RadioLat[7] = 'S';

	i = labs(DPRS.Long) % 10000;
	i = i * 6 + 5;
	i /= 10;
	sprintf ((char *)RadioLong, "%03ld%02ld.%02ld",labs(DPRS.Long)/10000, i/100, i%100);
	if (DPRS.Long >= 0) RadioLong[8] = 'E';
	else RadioLong[8] = 'W';
    
	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			id[k] = DPRS.CallSign[i];
			k++;
		}
		else
		{
			if (k > 0)
			{
				if(id[k-1] != '-')
				{
					id[k] = '-';
					k++;
				}
			}
		}
	}
	id[k] = 0x00;

	msg_len = strlen((char *)DPRS.Comment);
	if (msg_len > 20) msg_len = 20;
	TCPPutArray (DprsSocket, id, k);
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,TCPIP*,qAC,",19);
	TCPPutArray (DprsSocket, id, k);
	TCPPutArray (DprsSocket, (BYTE *)":=", 2);
	TCPPutArray (DprsSocket, RadioLat, 8);
	TCPPut (DprsSocket, 'D');
	TCPPutArray (DprsSocket, RadioLong, 9);
	TCPPut (DprsSocket, '&');
	if (msg_len > 0) TCPPutArray (DprsSocket, DPRS.Comment, msg_len);
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);
	DprsBeaconTimer = TickGet();
}

static	void	GetDprsMessage()
{
	static	char 	*msg, *msge, *msgstart, *msgend, *dstpnt, *msglast;
	static	WORD	len, k1;
	static	BYTE	id[10];
	static	struct	AprsCallTable	*NextTable;

	len = TCPGetArray(DprsSocket, DprsTemp, 500);
	if (len == 0) return;

	if (Msg.connectSW || Msg.notfoundSW || ReqLoadAprsCallCheck) return;

	msgstart = (char *)&DprsTemp;	
	msglast = msgstart + len - 1;
	DprsTemp[len++] = 0x00;
	DprsTemp[len] = 0x00;
	
	dstpnt = strstr(msgstart, "::");
skip:
	if (!dstpnt) return;
	if (*(dstpnt-1) == '`')
	{
		dstpnt = strstr(dstpnt+2, "::");
		goto skip;
	}

next:
	if (msgstart >= msglast) return;
	msgend = strstr (msgstart, "\r\n");	
	if (!msgend) return;
	if (msgend < dstpnt)
	{
		msgstart = msgend + 2;
		goto next;
	}
	*msgend = 0x00;

	if (dstpnt+11 > msgend)
	{
		msgstart = msgend + 2;
		goto next;
	}		
	if (*(dstpnt+11) != ':')
	{
		msgstart = msgend + 2;
		goto next;
	}		

	msg = strstr (msgstart, "qAC");
	if (!msg) msg = strstr (msgstart, "qAS");
	if (!msg) msg = strstr (msgstart, "qAR");
	if (!msg) return;
	if (!memcmp(msg+4, "AE5PL-JF", 8)) return;
	if (*(dstpnt+12) == 0x00) return;

	if ((dstpnt+14) <= msgend)
	{
		memset (id, 0x20, 9);
		if (strstr(dstpnt+12, "ack"))
		{
			if (memcmp(dstpnt+2, AprsSenderCall, strlen((char *)AprsSenderCall))) return;		/* skip ack message */
			RcvAprsSeq = atol (dstpnt+15);
			return; 			
		}
	}		

	msge = strchr (msgstart, '>');
	if (!msge) return;
	k1 = msge - msgstart;	/* skip space */
	if (!k1) return;
	memcpy (DprsMsgDstCallSign, dstpnt+2, 9);
	NextTable = AprsCallTablePnt;
	while  (NextTable)
	{
		if (NextTable->CallLength == 0) goto Find;
		if (!memcmp (&DprsMsgDstCallSign, NextTable->CallSign, NextTable->CallLength)) goto Find;
		NextTable = NextTable->Next;
	}
	return;

Find:
	if (memcmp(DprsMsgDstCallSignSave, DprsMsgDstCallSign, 9))
	{
		DprsMsgDstCallSign[9] = 'S';		/* check Destination call */
		while (DprsMsgDstCallSign[9] == 'S') vTaskDelay(5 / portTICK_RATE_MS);
		if (DprsMsgDstCallSign[9] == 'N') return;	/* not found */
		memcpy (DprsMsgDstCallSignSave, DprsMsgDstCallSign, 9);
	} 

	memset (DprsMsgSrcCallSign, 0x20, 9);
	memcpy (DprsMsgSrcCallSign, msgstart, k1);

	DprsMsgSend((BYTE *)dstpnt+12);

	msg = strchr (dstpnt+12, '{');
	if (!msg) return;

	msg++;
	msge = msg;
	if (msge >= msgend) return;
	while (*msge != 0x00)
	{
		if (msge >= msgend) break;
		msge++;
	}
	if (msg == msge) return;
	*msge = 0x00;
	if ((msge - msg) <= 5)  DprsAck((BYTE *)msg); 
}

void	AprsMsgSend()
{
	extern	BYTE	AprsSenderCall[10];
	static	BYTE	seqID[8];
	static	BYTE	k;

	if(TCPIsPutReady(DprsSocket) < 200u) return;

	AprsMessageSend = FALSE;

	for (i = 0 ; i < 9 ; i++)
	{
		if (AprsDest[i] <= 0x20) AprsDest[i] = 0x00;
	}
	if (AprsDest[0] == 0x00) return;

	if (!strlen((char *)AprsMessage))return;

	TCPPutArray (DprsSocket, AprsSenderCall, strlen((char *)AprsSenderCall));
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,TCPIP*",14);
	TCPPutArray (DprsSocket, (BYTE *)"::",2);
	k = strlen ((char *)AprsDest);
	if (k > 9) k = 9;
	TCPPutArray (DprsSocket, AprsDest, k);
	k = 9 - k;
	if (k) TCPPutArray (DprsSocket, (BYTE *)"         ", k);
	TCPPut (DprsSocket, ':');
	TCPPutArray (DprsSocket, AprsMessage, strlen((char *)AprsMessage));
	TCPPut (DprsSocket, '{');
	sprintf ((char *)seqID, "%-ld", AprsSeq);
	TCPPutArray (DprsSocket, seqID, strlen((char *)seqID));
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);
}

static	void	DprsMsgSend(BYTE Msg[])
{
	static	BYTE	tmp[138];
	static	WORD	len, i, k, j;

	memset (tmp, 0x20, 40);
	memcpy (tmp, DprsMsgSrcCallSign, 9);
	memcpy (&tmp[10], DprsMsgDstCallSign, 9);
	len = strlen ((char *)Msg);
	if (!len) return;
	k = 0;
	for (i = 0 ; i < len ; i++)
	{
		if ((Msg[i] == '{') || (Msg[i] == 0x00)) break;
		k++;			 	
	}
	if (k == 0) return;
	if (k > 67) k = 67;
	j = k;
	if (j > 20) j = 20;
	if (j > 0)
	{
		memcpy (&tmp[20], Msg, j);
		if (!memcmp (AprsMsgTX, "ON" , 2)) xQueueSend( xDstarDprsMsgQueue, tmp, 0 );
	}
	
	if (EmailAddress[0] != 0x00)
	{
		memset (tmp, 0x00, 138);
		memcpy (&tmp, DprsMsgSrcCallSign, 9);
		memcpy (&tmp[10], DprsMsgDstCallSign, 9);
		memcpy (&tmp[20], Msg, k);
		memcpy (&tmp[90], EmailAddress, 48);
		xQueueSend( xDstarDprsEmailMsgQueue, tmp, 0 );
	}
}

static	void	DprsAck(BYTE SeqID[])
{
	static	BYTE	PathID[9];
	static	long int i, kk;

	if(TCPIsPutReady(DprsSocket) < 70u) return;

	kk = 0;
	for (i = 0 ; i < 9 ; i++)
	{
		if (DprsMsgDstCallSign[i] != 0x20) kk++;
	}

	TCPPutArray (DprsSocket, DprsMsgDstCallSign, kk);
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,TCPIP*,qAC,",19);

	kk = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			PathID[kk] = DPRS.CallSign[i];
			kk++;
		}
		else
		{
			if (kk > 0)
			{
				if(PathID[kk-1] != '-')
				{
					PathID[kk] = '-';
					kk++;
				}
			}
		}
	}
	PathID[kk] = 0x00;

	TCPPutArray (DprsSocket, PathID, kk);
	TCPPutArray (DprsSocket, (BYTE *)"::", 2);
	TCPPutArray (DprsSocket, DprsMsgSrcCallSign, 9);
	TCPPutArray (DprsSocket, (BYTE *)":ack", 4);
	i = strlen ((char *)SeqID);
	TCPPutArray (DprsSocket, SeqID, i);
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);
}
